<?php
/*
Widget Name: Testimonials Carousel
Description: Testimonials Carousel
*/

class Testimonials_Row extends SiteOrigin_Widget {

	function get_template_name($instance) {
    return 'widget-template';
}

function get_template_dir($instance) {
    return 'templates';
}

function __construct() {
   
    //Call the parent constructor with the required arguments.
    parent::__construct(
        // The unique id for your widget.
        'testimonials-row',

        // The name of the widget for display purposes.
        'Testimonials Carousel',

        // The $widget_options array, which is passed through to WP_Widget.
        // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
        array(
            'panels_groups' => array('nh')
        ),

        //The $control_options array, which is passed through to WP_Widget
        array(
        ),

        //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
        array(
			'class_cust' => array(
				'type' => 'text',
				'label' => 'Cust class(do not delete)',
				'default' => ''
			),
			'list_item' => array(
				'type' => 'repeater',
				'label' => __( 'Testimonials slider' , 'widget-form-fields-text-domain' ),
				'item_name'  => __( 'Testimonial item', 'siteorigin-widgets' ),
				'item_label' => array(
					'selector'     => "[id*='name']",
					'update_event' => 'change',
					'value_method' => 'val'
				),
				'fields' => array(
				/*
					'icon_png' => array(
						'type' => 'media',
						'label' => __( 'Profile image', 'widget-form-fields-text-domain' ),
						'choose' => __( 'Choose image', 'widget-form-fields-text-domain' ),
						'update' => __( 'Set image', 'widget-form-fields-text-domain' ),
						'library' => 'image',
						'fallback' => true
					),
					*/
					'name' => array(
						'type' => 'textarea',
						'label' => 'Name',
						'default' => ''
					),
					/*
					'position' => array(
						'type' => 'textarea',
						'label' => 'Position',
						'default' => ''
					),
					*/
					'text_profile' => array(
						'type' => 'tinymce',
						'label' => __( 'Text', 'widget-form-fields-text-domain' ),
						'default' => '',
						'rows' => 10,
						'default_editor' => 'html',
						'button_filters' => array(
							'mce_buttons' => array( $this, 'filter_mce_buttons' ),
							'mce_buttons_2' => array( $this, 'filter_mce_buttons_2' ),
							'mce_buttons_3' => array( $this, 'filter_mce_buttons_3' ),
							'mce_buttons_4' => array( $this, 'filter_mce_buttons_5' ),
							'quicktags_settings' => array( $this, 'filter_quicktags_settings' ),
						),
					),
				)
			),
        ),

        //The $base_folder path string.
        plugin_dir_path(__FILE__)
    );
}
}

siteorigin_widget_register('testimonials-row', __FILE__, 'Testimonials_Row');