<?php
/*
Widget Name: Empty space
Description: Empty space
*/

class Empty_space extends SiteOrigin_Widget {

	function get_template_name($instance) {
    return 'widget-template';
}

function get_template_dir($instance) {
    return 'templates';
}

function __construct() {
   
    //Call the parent constructor with the required arguments.
    parent::__construct(
        // The unique id for your widget.
        'empty-space',

        // The name of the widget for display purposes.
        'Empty space',

        // The $widget_options array, which is passed through to WP_Widget.
        // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
        array(
            'panels_groups' => array('nh')
        ),

        //The $control_options array, which is passed through to WP_Widget
        array(
        ),

        //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
        array(
			'add_class' => array(
				'type' => 'text',
				'label' => "Add Class",						
			),
			'usage' => array(
				'type' => 'select',
				'label' => __( 'Space usage', 'widget-form-fields-text-domain' ),
				'default' => 'all_rezolutions',
				'options' => array(
					'all_rezolutions' => __( 'All Screen Sizes', 'widget-form-fields-text-domain' ),
					'just_mobile' => __( 'Just mobile', 'widget-form-fields-text-domain' ),
					
				)
			), 
			'height_choose' => array(
				'type' => 'select',
				'label' => __( 'Select space', 'widget-form-fields-text-domain' ),
				'default' => 'small_space',
				'options' => array(
					'extra_small_space' => __( 'Extra Small Space', 'widget-form-fields-text-domain' ),
					'small_space' => __( 'Small Space', 'widget-form-fields-text-domain' ),
					'medium_space' => __( 'Medium Space', 'widget-form-fields-text-domain' ),
					'large_space' => __( 'Large Space', 'widget-form-fields-text-domain' ),
					'extra_large_space' => __( 'Extra Large Space', 'widget-form-fields-text-domain' ),
					
				)
			),		
        ),

        //The $base_folder path string.
        plugin_dir_path(__FILE__)
    );
}
}

siteorigin_widget_register('empty-space', __FILE__, 'Empty_space');