<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package noble_house_theme_web
 */

get_header();

$replacer_top_image = get_theme_mod('replacer_top_image');

?>


<div class="image_top_header_single" style="background-image:url('<?php echo @$replacer_top_image; ?>');">
	<div class="cotent_header_small"> 
		<h1 class="bar_top_title"><?php
			/* translators: %s: search query. */
			printf( esc_html__( 'Search Results for: %s', 'rutland_theme_trl' ), '<span>' . get_search_query() . '</span>' );
		?></h1>
	</div>
</div>


	<main id="primary" class="site-main">
		<div class="large_container">
		<?php if ( have_posts() ) : ?>
	
			<?php
			
			echo '<div class="container_search_element">'; 
			/* Start the Loop */
			while ( have_posts() ) :
				the_post();

				/**
				 * Run the loop for the search to output the results.
				 * If you want to overload this in a child theme then include a file
				 * called content-search.php and that will be used instead.
				 */
				
					get_template_part( 'template-parts/content', 'search' );
				
			endwhile;
			echo '</div><div class="navigation_search"> ';
			
			wp_pagenavi();
			
			echo '</div>';
		else :
			get_template_part( 'template-parts/content', 'none' );
			
			
			
		endif;
		?>
		</div>
		
	</main><!-- #main -->

<?php
get_footer();
