<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package noble_house_theme_web
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
	<link rel="profile" href="https://gmpg.org/xfn/11">
       <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Lato:wght@300;400;700;900&family=Source+Sans+Pro:wght@300;400;700&display=swap" rel="stylesheet">
	<?php wp_head(); ?>
	<script type="text/javascript">
		var theme_path = "<?php echo get_stylesheet_directory_uri();?>";
		var ajaxurl_register = "<?php echo admin_url( 'admin-ajax.php' );?>";
		var site_url = '<?php echo site_url(); ?>';
	</script>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open();
$logo_site = get_theme_mod('logo_header');
$feature1_id = attachment_url_to_postid($logo_site);
// This is getting the alt text from the image that is set in the media area
$image1_alt = get_post_meta( $feature1_id, '_wp_attachment_image_alt', true );

$count_htm ='';

if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
    $count = WC()->cart->cart_contents_count;
    //woocommerce_cart_page_id
    if ( $count > 0 ) {
        $count_htm='<a class="count_cart_header" href="'.get_permalink( get_option('woocommerce_cart_page_id') ).'"><div class="cart_contents_div has_elem_cart"><i class="fa fa-shopping-cart" aria-hidden="true"></i><span class="cart_contents_count">'.esc_html(@$count).'</span>
</div></a>';  
    }
    else{
        $count_htm='<a  class="count_cart_header"  href="'.site_url().'"><div class="cart_contents_div has_elem_cart"><i class="fa fa-shopping-cart" aria-hidden="true"></i>
</div></a>';
    }
}
$image_header = get_theme_mod('replacer_top_image');
 ?>
<div id="page" class="site">
	

<header id="masthead" class="site_header">
    <div class="header_site_content">
        <div class="middle_container">
            <div class="left_side_header">
                <div class="socials_header">
                    <?php dynamic_sidebar('socials_area'); ?>
                </div>
            </div>
            <div class="logo_side_header">
                <a class="site_url_top" href="<?php echo site_url(); ?>"><img class="logo_header" src="<?php echo $logo_site; ?>" alt="<?php echo  $image1_alt;?>" /></a>
            </div>
            <div class="right_side_header">
                <div class="contact_header">
                    <?php dynamic_sidebar('contact_details'); ?>
                </div>
                <div class="header_cart">
                    <?php echo @$count_htm; ?>
                </div>
            </div>
        </div>
    </div>
</header><!-- #masthead -->

<?php 
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
    if(is_cart() || is_product() || is_checkout() || is_account_page()){
        echo '<div class="image_top_header_single" style="background-image:url(\''.$image_header.'\');">
	<div class="cotent_header_small">'; 
           if(!is_product()){
               echo '<h1 class="bar_top_title" >'.get_the_title().'</h1>';
           }
	 echo '</div>
</div>';
    }
}


?>
